@extends('emails.base')

@section('header', 'New Transaction Created')

@section('slot')

@if($transaction->type == 'investment')
{{-- Investment Transaction --}}
<div style="text-align: center; margin: 0 0 32px 0;">
    <div style="background: linear-gradient(135deg, #3b82f6 0%, #2563eb 100%); border-radius: 50%; width: 80px; height: 80px; margin: 0 auto 20px; display: flex; align-items: center; justify-content: center; box-shadow: 0 8px 24px rgba(59, 130, 246, 0.3);">
        <img src="{{ asset('icons/investment.gif') }}" alt="" style="width: 100%; aspect-ratio:1; border-radius:100%">
    </div>
    <h1 style="font-size: 28px; color: #111827; margin: 0 0 8px 0; font-weight: 700;">Investment Created!</h1>
    <p style="font-size: 18px; color: #6b7280; margin: 0;">Your robots are being deployed</p>
</div>

<div style="background: linear-gradient(135deg, #eff6ff 0%, #dbeafe 100%); padding: 32px; border-radius: 16px; text-align: center; margin: 24px 0; border: 3px solid #3b82f6; box-shadow: 0 4px 16px rgba(59, 130, 246, 0.15);">
    <div style="font-size: 48px; font-weight: 800; color: #1e40af; margin: 0 0 12px 0;">
        ${{ rtrim(rtrim(number_format($transaction->amount_usd, 2, '.', ''), '0'), '.') }}
    </div>
    <p style="margin: 0 0 16px 0; color: #1e40af; font-size: 18px; font-weight: 600;">
        {{ $transaction->investment->scheme->scheme_name }}
    </p>
    <div style="display: flex; justify-content: center; gap: 24px; flex-wrap: wrap; margin-top: 16px;">
        <div style="text-align: center;">
            <p style="margin: 0; color: #1e3a8a; font-size: 24px; font-weight: 700;">{{ $transaction->investment->scheme->interest_rate }}%</p>
            <p style="margin: 4px 0 0 0; color: #3b82f6; font-size: 13px;">Weekly Returns</p>
        </div>
        <div style="text-align: center;">
            <p style="margin: 0; color: #1e3a8a; font-size: 24px; font-weight: 700;">{{ $transaction->investment->scheme->risk_exposure_percentage }}%</p>
            <p style="margin: 4px 0 0 0; color: #3b82f6; font-size: 13px;">Risk Level</p>
        </div>
    </div>
</div>

<div style="background: rgba(249, 250, 251, 0.8); padding: 20px; border-radius: 12px; margin: 20px 0;">
    <p style="margin: 0 0 12px 0; color: #374151; font-size: 15px; line-height: 1.6;">
        {{ $transaction->investment->scheme->description }}
    </p>
    <p style="margin: 0; color: #6b7280; font-size: 13px;">
        <strong>Status:</strong> {{ ucfirst($transaction->status) }} • <strong>Plan:</strong> {{ $transaction->investment->interest_plan }}
    </p>
</div>

@if($transaction->status == 'pending' || $transaction->status == \App\Enums\StatusEnum::PENDING)
<div style="background: linear-gradient(135deg, #fef3c7 0%, #fde68a 100%); padding: 24px; border-radius: 12px; border-left: 5px solid #f59e0b; margin: 20px 0; box-shadow: 0 4px 12px rgba(245, 158, 11, 0.15);">
    <p style="margin: 0 0 16px 0; color: #92400e; font-size: 17px; font-weight: 700;">
        ⚡ Next Steps - Complete Your Payment
    </p>
    <p style="margin: 0 0 16px 0; color: #78350f; font-size: 15px; line-height: 1.7;">
        Your investment is ready to go! To activate your robots and start earning:
    </p>
    <ul style="margin: 0; padding-left: 20px; color: #92400e; font-size: 14px; line-height: 1.8;">
        <li style="margin-bottom: 8px;">Visit the transaction page to complete your payment</li>
        <li style="margin-bottom: 8px;">Your investment will be <strong>activated immediately</strong> upon receiving your deposit</li>
        <li>Once activated, your robots will begin working and generating returns</li>
    </ul>
</div>
@endif

@if($transaction->admin_remark)
<div style="background: #e0e7ff; padding: 16px; border-radius: 8px; border-left: 4px solid #6366f1; margin: 20px 0;">
    <p style="margin: 0; color: #3730a3; font-size: 14px;">
        <strong>📝 Admin Note:</strong> {{ $transaction->admin_remark }}
    </p>
</div>
@endif

@elseif($transaction->type == 'bonus')
{{-- Bonus Transaction --}}
<div style="text-align: center; margin: 0 0 32px 0;">
    <div style="background: linear-gradient(135deg, #8b5cf6 0%, #7c3aed 100%); border-radius: 50%; width: 80px; height: 80px; margin: 0 auto 20px; display: flex; align-items: center; justify-content: center; box-shadow: 0 8px 24px rgba(139, 92, 246, 0.3);">
        <img src="{{ asset('icons/bonus.gif') }}" alt="" style="width: 100%; aspect-ratio:1; border-radius:100%">
    </div>
    <h1 style="font-size: 28px; color: #111827; margin: 0 0 8px 0; font-weight: 700;">Bonus Received! 🎉</h1>
    <p style="font-size: 18px; color: #6b7280; margin: 0;">Your account has been credited</p>
</div>

<div style="background: linear-gradient(135deg, #faf5ff 0%, #f3e8ff 100%); padding: 32px; border-radius: 16px; text-align: center; margin: 24px 0; border: 3px solid #8b5cf6; box-shadow: 0 4px 16px rgba(139, 92, 246, 0.15);">
    <div style="font-size: 48px; font-weight: 800; color: #6b21a8; margin: 0 0 8px 0;">
        ${{ rtrim(rtrim(number_format($transaction->amount_usd, 2, '.', ''), '0'), '.') }}
    </div>
    <p style="margin: 0; color: #7c3aed; font-size: 15px;">
        <strong>Status:</strong> {{ ucfirst($transaction->status) }}
    </p>
</div>

@elseif($transaction->type == 'withdrawal')
{{-- Withdrawal Transaction --}}
<div style="text-align: center; margin: 0 0 32px 0;">
    <div style="background: linear-gradient(135deg, #f59e0b 0%, #d97706 100%); border-radius: 50%; width: 80px; height: 80px; margin: 0 auto 20px; display: flex; align-items: center; justify-content: center; box-shadow: 0 8px 24px rgba(245, 158, 11, 0.3);">
        <img src="{{ asset('icons/withdrawal.gif') }}" alt="" style="width: 100%; aspect-ratio:1; border-radius:100%">
    </div>
    <h1 style="font-size: 28px; color: #111827; margin: 0 0 8px 0; font-weight: 700;">Withdrawal Requested</h1>
    <p style="font-size: 18px; color: #6b7280; margin: 0;">Processing your request</p>
</div>

<div style="background: linear-gradient(135deg, #fffbeb 0%, #fef3c7 100%); padding: 32px; border-radius: 16px; text-align: center; margin: 24px 0; border: 3px solid #f59e0b; box-shadow: 0 4px 16px rgba(245, 158, 11, 0.15);">
    <div style="font-size: 48px; font-weight: 800; color: #92400e; margin: 0 0 8px 0;">
        ${{ rtrim(rtrim(number_format($transaction->amount_usd, 2, '.', ''), '0'), '.') }}
    </div>
    <p style="margin: 0; color: #b45309; font-size: 15px;">
        <strong>Status:</strong> {{ ucfirst($transaction->status) }}
    </p>

    @if(isset($transaction->method_info['address']))
    <div style="background: rgba(255, 255, 255, 0.6); padding: 16px; border-radius: 8px; margin-top: 16px; text-align: left;">
        <p style="margin: 0 0 8px 0; color: #92400e; font-size: 13px; font-weight: 600;">
            📍 Destination:
        </p>
        <p style="margin: 0; color: #b45309; font-size: 13px; word-break: break-all; font-family: 'Courier New', monospace;">
            {{ $transaction->method_info['address'] }}
        </p>
        @if(isset($transaction->method_info['network']))
        <p style="margin: 8px 0 0 0; color: #d97706; font-size: 13px;">
            <strong>Network:</strong> {{ $transaction->method_info['network'] }}
        </p>
        @endif
    </div>
    @endif
</div>

@else
{{-- Generic Transaction --}}
<div style="text-align: center; margin: 0 0 24px 0;">
    <h1 style="font-size: 24px; color: #111827; margin: 0 0 8px 0; font-weight: 700;">New Transaction</h1>
    <p style="font-size: 16px; color: #6b7280; margin: 0;">Transaction ID: {{ $transaction->id }}</p>
</div>
@endif

@if(!empty($transaction->method_info['remark']))
<div style="background: #f3f4f6; padding: 16px; border-radius: 8px; margin: 20px 0;">
    <p style="margin: 0; color: #374151; font-size: 14px;">
        <strong>💬 Remark:</strong> {{ $transaction->method_info['remark'] }}
    </p>
</div>
@endif

<div style="text-align: center; margin: 32px 0;">
    @if($transaction->status == 'pending' || $transaction->status == \App\Enums\StatusEnum::PENDING)
    <a href="{{ system_setting('site_url') }}/transactions/{{ $transaction->id }}" style="display: inline-block; background: linear-gradient(135deg, #ef4444 0%, #dc2626 100%); color: white; padding: 16px 32px; text-decoration: none; border-radius: 12px; font-weight: 600; font-size: 16px; box-shadow: 0 4px 12px rgba(239, 68, 68, 0.3); margin: 0 8px 8px 8px;">
        💳 Complete Payment
    </a>
    @endif
    <a href="{{ system_setting('site_url') }}/dashboard" style="display: inline-block; background: linear-gradient(135deg, #10b981 0%, #059669 100%); color: white; padding: 16px 32px; text-decoration: none; border-radius: 12px; font-weight: 600; font-size: 16px; box-shadow: 0 4px 12px rgba(16, 185, 129, 0.3); margin: 0 8px 8px 8px;">
        📊 View Details
    </a>
</div>

@if (empty($transaction->method_info['is_added_by_admin']))
<p style="font-size: 13px; color: #6b7280; text-align: center; margin: 24px 0 0 0;">
    Didn't initiate this? <a href="mailto:{{ system_setting('support_email') }}" style="color: #ef4444; text-decoration: none; font-weight: 600;">Contact Support</a>
</p>
@endif

@endsection
