@extends('emails.base')

@section('header', 'Withdrawal Confirmed')

@section('slot')
<div style="text-align: center; margin: 0 0 32px 0;">
    <div style="background: linear-gradient(135deg, #10b981 0%, #059669 100%); border-radius: 50%; width: 80px; height: 80px; margin: 0 auto 20px; display: flex; align-items: center; justify-content: center; box-shadow: 0 8px 24px rgba(16, 185, 129, 0.3);">
        <img src="{{ asset('icons/success.gif') }}" alt="" style="width: 100%; aspect-ratio:1; border-radius::100%">
    </div>
    <h1 style="font-size: 28px; color: #111827; margin: 0 0 8px 0; font-weight: 700;">Withdrawal Successful!</h1>
    <p style="font-size: 18px; color: #6b7280; margin: 0;">Your profits are on the way</p>
</div>

<div style="background: linear-gradient(135deg, #f0fdf4 0%, #dcfce7 100%); padding: 32px; border-radius: 16px; text-align: center; margin: 24px 0; border: 3px solid #10b981; box-shadow: 0 4px 16px rgba(16, 185, 129, 0.15);">
    <div style="font-size: 48px; font-weight: 800; color: #047857; margin: 0 0 8px 0;">
        ${{ rtrim(rtrim(number_format($transaction->amount_usd, 2, '.', ''), '0'), '.') }}
    </div>
    <p style="margin: 0; color: #065f46; font-size: 15px;">
        <strong>{{ $transaction->payment_method }}</strong> • {{ $transaction->updated_at->format('M d, Y') }}
    </p>
    @if(isset($transaction->method_info['currency']))
    <p style="margin: 8px 0 0 0; color: #059669; font-size: 14px;">
        {{ strtoupper($transaction->method_info['currency']) }}
    </p>
    @endif

    @if(isset($transaction->method_info['wallet_from']))
    <div style="background: rgba(255, 255, 255, 0.6); padding: 16px; border-radius: 8px; margin-top: 16px; text-align: left;">
        <p style="margin: 0 0 8px 0; color: #065f46; font-size: 13px; font-weight: 600;">
            💳 Withdrawn From:
        </p>
        <p style="margin: 0; color: #047857; font-size: 14px; font-weight: 500;">
            {{ ucwords(str_replace('_', ' ', $transaction->method_info['wallet_from'])) }}
        </p>
    </div>
    @endif

    @if(isset($transaction->method_info['address']))
    <div style="background: rgba(255, 255, 255, 0.6); padding: 16px; border-radius: 8px; margin-top: 12px; text-align: left;">
        <p style="margin: 0 0 8px 0; color: #065f46; font-size: 13px; font-weight: 600;">
            📍 Destination Address:
        </p>
        <p style="margin: 0; color: #047857; font-size: 13px; word-break: break-all; font-family: 'Courier New', monospace;">
            {{ $transaction->method_info['address'] }}
        </p>
    </div>
    @endif
</div>

<p style="font-size: 16px; color: #374151; line-height: 1.7; text-align: center; margin: 24px 0;">
    Your robots continue working 24/7, generating more income while you enjoy these profits.
</p>

<p style="font-size: 14px; color: #6b7280; text-align: center; margin: 24px 0 0 0;">
    Keep building your automated income stream
</p>
@endsection
