<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html xmlns="http://www.w3.org/1999/xhtml" lang="en">

@php
$learnMoreUrl = 'https://info.dnxgroup.com/learnmore';
$referralUrl = 'https://info.dnxgroup.com/affiliate-';
$videoUrl = 'https://info.dnxgroup.com/real-robots';
$registerUrl = 'https://dash.dnxgroup.com/auth';

@endphp

<head>
    <meta http-equiv="Content-Type" content="text/html; charset=UTF-8" />
    <meta name="viewport" content="width=device-width, initial-scale=1.0" />
    <title>{{ $subject ?? 'Email' }}</title>
    <style type="text/css">
        /* Client-specific styles */
        body,
        table,
        td,
        a {
            -webkit-text-size-adjust: 100%;
            -ms-text-size-adjust: 100%;
        }

        table,
        td {
            mso-table-lspace: 0pt;
            mso-table-rspace: 0pt;
        }

        img {
            -ms-interpolation-mode: bicubic;
            border: 0;
            height: auto;
            line-height: 100%;
            outline: none;
            text-decoration: none;
        }

        /* Reset styles */
        body {
            margin: 0 !important;
            padding: 0 !important;
            width: 100% !important;
        }

        /* iOS BLUE LINKS */
        a[x-apple-data-detectors] {
            color: inherit !important;
            text-decoration: none !important;
            font-size: inherit !important;
            font-family: inherit !important;
            font-weight: inherit !important;
            line-height: inherit !important;
        }

        /* Main styles */
        body {
            font-family: Arial, sans-serif;
            background-color: #f3f4f6;
            color: #4b5563;
        }

        .email-container {
            width: 100%;
            max-width: 600px;
            margin: 0 auto;
        }

        .header {
            background-color: #f9fafb;
            padding: 24px;
            text-align: center;
        }


        .highlight {
            background-color: #f8f9fa;
            padding: 15px;
            border-left: 4px solid #4CAF50;
            margin: 15px 0;
        }

        .cta {
            margin: 25px 0;
            text-align: center;
            display: flex;
            flex-wrap: wrap;
            gap: 1rem
        }

        .cta a {
            background-color: #4CAF50;
            color: white;
            padding: 10px 15px;
            text-decoration: none;
            border-radius: 4px;
            display: inline-block;
            margin: 5px;
            flex-grow: 1
        }

        ul.checklist {
            list-style-type: none;
            padding-left: 5px;
        }

        ul.checklist li:before {
            content: "✓ ";
            color: #4CAF50;
            font-weight: bold;
        }


        .logo {
            max-width: 170px;
            height: auto;
        }

        .content {
            /* padding: 20px; */
            font-size: 16px;
            line-height: 1.6;
        }

        .footer {
            background-color: #f9fafb;
            padding: 24px;
            text-align: center;
        }

        .social-icons {
            margin-bottom: 20px;
        }

        .social-icon {
            display: inline-block;
            margin: 0 6px;
        }

        .button {
            display: inline-block;
            padding: 12px 24px;
            background-color: #10b981;
            color: #ffffff;
            text-decoration: none;
            border-radius: 24px;
            font-weight: bold;
            margin: 8px;
        }

        .register-button {
            display: block;
            padding: 10px 0;
            background-color: #3b82f6;
            color: #ffffff;
            text-decoration: none;
            border-radius: 8px;
            font-weight: bold;
            border: 2px solid #3b82f6;
            text-align: center;
            width: 100%;
            box-shadow: 0 2px 4px rgba(0, 0, 0, 0.1);
        }

        .video-button {
            display: block;
            padding: 10px 0;
            background-color: #ef4444;
            color: #ffffff;
            text-decoration: none;
            border-radius: 8px;
            font-weight: bold;
            border: 2px solid #ef4444;
            text-align: center;
            width: 100%;
            box-shadow: 0 2px 4px rgba(0, 0, 0, 0.1);
        }

        .learn-button {
            display: block;
            padding: 10px 0;
            background-color: #f59e0b;
            color: #ffffff;
            text-decoration: none;
            border-radius: 8px;
            font-weight: bold;
            border: 2px solid #f59e0b;
            text-align: center;
            width: 100%;
            box-shadow: 0 2px 4px rgba(0, 0, 0, 0.1);
        }

        .referral-button {
            display: block;
            padding: 10px 0;
            background-color: #8b5cf6;
            color: #ffffff;
            text-decoration: none;
            border-radius: 8px;
            font-weight: bold;
            border: 2px solid #8b5cf6;
            text-align: center;
            width: 100%;
            box-shadow: 0 2px 4px rgba(0, 0, 0, 0.1);
        }

        .button-container {
            margin-top: 32px;
            text-align: center;
        }

        .button-row {
            width: 100%;
            margin: 8px 0;
        }

        .button-cell {
            width: 50%;
            padding: 0 4px;
        }

        .links-heading {
            font-size: 18px;
            font-weight: bold;
            color: #1f2937;
            margin: 24px 0 16px 0;
            text-align: center;
        }

        .footer-text {
            color: #6b7280;
            font-size: 12px;
            line-height: 1.5;
            margin: 0;
        }

    </style>
</head>

<body style="margin: 0; padding: 0; background-color: #f3f4f6;">
    <table class="email-container" align="center" width="100%" cellpadding="0" cellspacing="0" border="0" style="max-width: 600px;">
        <!-- Header -->
        <tr>
            <td class="header" style="text-align: center; padding: 24px; background-color: #f9fafb;">
                <table width="100%" cellpadding="0" cellspacing="0" border="0">
                    <tr>
                        <td align="left" width="50%">
                            <img class="logo" src="https://dnxgroup.com/assets/logoblack-B_wj55kc.png" alt="Company Logo" style="max-width: 170px; height: auto;" />
                        </td>
                        <td align="right" width="50%">
                            <table cellpadding="0" cellspacing="0" border="0" align="right">
                                <tr>
                                    <td class="social-icon"><a href="https://youtube.com/@dnxgroup?si=UqASL0KTQQ_7eWuS"><img src="https://cdn-icons-png.flaticon.com/24/1384/1384060.png" alt="YouTube" width="24" height="24" style="display: block;" /></a></td>
                                </tr>
                            </table>
                        </td>
                    </tr>
                </table>
            </td>
        </tr>

        <!-- Content -->
        <tr>
            <td class="content" style="padding: 20px; color: #4b5563; font-size: 16px; line-height: 1.6;">
                <strong>Dear {{ $user->first_name }} {{ $user->last_name }}, </strong><br>
                @yield('slot')

                <div class="button-container" style="margin-top: 32px; text-align: center;">
                    @if(isset($actionText) && isset($actionUrl))
                    <a href="{{ $actionUrl }}" class="button" style="display: inline-block; padding: 12px 24px; background-color: #10b981; color: #ffffff; text-decoration: none; border-radius: 24px; font-weight: bold; margin: 8px;">
                        {{ $actionText }}
                    </a>
                    @endif

                    <!-- Useful Links Heading -->
                    <h3 class="links-heading" style="font-size: 18px; font-weight: bold; color: #1f2937; margin: 24px 0 16px 0; text-align: center;">Useful Links</h3>

                    <!-- First row with two buttons -->
                    <table class="button-row" width="100%" cellpadding="0" cellspacing="0" style="margin: 8px 0;">
                        <tr>
                            <td class="button-cell" width="50%" style="padding: 0 4px;">
                                <a href="{{ $registerUrl }}" style="display: block; padding: 10px 0; background-color: #2563eb; color: #ffffff; text-decoration: none; border-radius: 8px; font-weight: bold; border: 2px solid #2563eb; text-align: center; width: 100%; box-shadow: 0 2px 4px rgba(0,0,0,0.1);">



                                    📈 Invest & Grow
                                </a>
                            </td>
                            <td class="button-cell" width="50%" style="padding: 0 4px;">
                                <a href="{{ $videoUrl ?? '#' }}" class="video-button" style="display: block; padding: 10px 0; background-color: #ef4444; color: #ffffff; text-decoration: none; border-radius: 8px; font-weight: bold; border: 2px solid #ef4444; text-align: center; width: 100%; box-shadow: 0 2px 4px rgba(0,0,0,0.1);">
                                    <img src="https://cdn-icons-png.flaticon.com/24/2965/2965938.png" width="16" height="16" style="vertical-align: middle; margin-right: 8px;" alt="" /> Watch Video
                                </a>
                            </td>
                        </tr>
                    </table>

                    <!-- Second row with two buttons -->
                    <table class="button-row" width="100%" cellpadding="0" cellspacing="0" style="margin: 8px 0;">
                        <tr>
                            <td class="button-cell" width="50%" style="padding: 0 4px;">
                                <a href="{{ $learnMoreUrl ?? '#' }}" class="learn-button" style="display: block; padding: 10px 0; background-color: #f59e0b; color: #ffffff; text-decoration: none; border-radius: 8px; font-weight: bold; border: 2px solid #f59e0b; text-align: center; width: 100%; box-shadow: 0 2px 4px rgba(0,0,0,0.1);">
                                    <img src="https://cdn-icons-png.flaticon.com/24/1570/1570887.png" width="16" height="16" style="vertical-align: middle; margin-right: 8px;" alt="" /> Learn More
                                </a>
                            </td>
                            <td class="button-cell" width="50%" style="padding: 0 4px;">
                                <a href="{{ $referralUrl ?? '#' }}" class="referral-button" style="display: block; padding: 10px 0; background-color: #8b5cf6; color: #ffffff; text-decoration: none; border-radius: 8px; font-weight: bold; border: 2px solid #8b5cf6; text-align: center; width: 100%; box-shadow: 0 2px 4px rgba(0,0,0,0.1);">
                                    <img src="https://cdn-icons-png.flaticon.com/24/9131/9131479.png" width="16" height="16" style="vertical-align: middle; margin-right: 8px;" alt="" /> Referral Program
                                </a>
                            </td>
                        </tr>
                    </table>
                </div>
            </td>
        </tr>

        <!-- Footer -->
        <tr>
            <td class="footer" style="padding: 24px; background-color: #f9fafb; text-align: center;">
                <table class="social-icons" cellpadding="0" cellspacing="0" border="0" align="center">
                    <tr>
                        <td class="social-icon"><a href="https://facebook.com"><img src="https://cdn-icons-png.flaticon.com/24/733/733547.png" alt="Facebook" width="24" height="24" style="display: block;" /></a></td>
                        <td class="social-icon"><a href="https://twitter.com"><img src="https://cdn-icons-png.flaticon.com/24/733/733579.png" alt="Twitter" width="24" height="24" style="display: block;" /></a></td>
                        <td class="social-icon"><a href="https://instagram.com"><img src="https://cdn-icons-png.flaticon.com/24/2111/2111463.png" alt="Instagram" width="24" height="24" style="display: block;" /></a></td>
                        <td class="social-icon"><a href="https://linkedin.com"><img src="https://cdn-icons-png.flaticon.com/24/174/174857.png" alt="LinkedIn" width="24" height="24" style="display: block;" /></a></td>
                        <td class="social-icon"><a href='https://youtube.com/@dnxgroup?si=UqASL0KTQQ_7eWuS'><img src="https://cdn-icons-png.flaticon.com/24/1384/1384060.png" alt="YouTube" width="24" height="24" style="display: block;" /></a></td>

                    </tr>
                </table>

                <p class="footer-text" style="color: #6b7280; font-size: 12px; line-height: 1.5; margin: 0;">
                    © {{ date('Y') }} DNX Group. All rights reserved.<br>
                    This email was sent to {{ $user->email }} because you've subscribed on our site or made a purchase.
                </p>
            </td>
        </tr>
    </table>
</body>

</html>
