<?php

namespace App;

use App\Models\SystemSettings;

class AffiliateBenefits {
    public array $benefits = [
        'direct_referral_bonus' => [
            'deposit_1' => 1,
            'deposit_2' => 0,
            'deposit_3' => 0,
            'subsequent_deposits' => 0,
            'referred_person_bonus' => 1,
            'deposit_bonus_up_to_times' => 3,
        ],
        'weekly_profit_from_direct' => [
            'percentage' => 0,
            'up_to_people' => 0,
            'max_weekly_profit' => 0,
        ],
        'indirect_referral_bonus' => [
            'deposit_1' => 0,
            'deposit_2' => 0,
            'deposit_3' => 0,
            'subsequent_deposits' => 0,
            'levels' => 0,
        ],
        'monthly_profit_from_indirects' => [
            'percentage' => 0,
            'up_to_people' => 0,
        ],
        'annual_promotional_payments' => [
            'min' => 0,
            'max' => 0,
        ],
        'required_indirect_referrals' => 0,
        'min_referrals_required_for_cashout' => 1,
        'premium_deposit_benefit' => 1,
    ];

    public function __construct() {
        $this->benefits[ 'premium_deposit_benefit' ] = system_setting( SystemSettings::PREMIUM_DEPOSIT_BONUS, 0 );
        $this->benefits[ 'direct_referral_bonus' ][ 'deposit_1' ] = ( float ) system_setting( SystemSettings::INITIAL_DEPOSIT_BONUS_PERCENTAGE, 0 );
        $this->benefits[ 'direct_referral_bonus' ][ 'referred_person_bonus' ] = ( float ) system_setting( SystemSettings::INITIAL_DEPOSIT_BENEFIT_PERCENTAGE, 0 );
        $this->benefits[ 'direct_referral_bonus' ][ 'deposit_bonus_up_to_times' ] = ( float ) system_setting( SystemSettings::MAX_SUB_DEPOSIT_COMMISION_LIMIT, 3 );
        $this->benefits[ 'direct_referral_bonus' ][ 'min_referrals_required_for_cashout' ] = ( float ) system_setting( SystemSettings::MIN_REFERRALS_REQUIRED_FOR_CASHOUT, 1 );
    }

    // Setters for direct referral bonuses

    public function setDirectReferralBonus( int $first, int $second, int $third, int $referredBonus, int $depositBonusUpToTimes = 1 ): static {
        $this->benefits[ 'direct_referral_bonus' ] = [
            'deposit_1' => $first,
            'deposit_2' => $second,
            'deposit_3' => $third,
            'referred_person_bonus' => $referredBonus,
            'deposit_bonus_up_to_times' => $depositBonusUpToTimes,
        ];
        return $this;
    }

    // Setters for weekly profit from direct referrals

    public function setWeeklyProfitFromDirect( int $percentage, int $upToPeople, int $maxWeeklyProfit = 0 ): static {
        $this->benefits[ 'weekly_profit_from_direct' ] = [
            'percentage' => $percentage,
            'up_to_people' => $upToPeople,
        ];
        return $this;
    }

    // Setters for indirect referral bonuses

    public function setIndirectReferralBonus( int $firstDeposit, int $secondDeposit, int $thirdDeposit, int $levels ): static {
        $this->benefits[ 'indirect_referral_bonus' ] = [
            'deposit_1' => $firstDeposit,
            'deposit_2' => $secondDeposit,
            'deposit_3' => $thirdDeposit,
            'levels' => $levels,
        ];
        return $this;
    }

    public function setMinReferralsRequiredForCashout( int $min_referrals_required_for_cashout ): static {
        $this->benefits[ 'min_referrals_required_for_cashout' ] = $min_referrals_required_for_cashout;
        return $this;
    }

    // Setters for monthly profit from indirect referrals

    public function setMonthlyProfitFromIndirects( int $percentage, int $upToPeople ): static {
        $this->benefits[ 'monthly_profit_from_indirects' ] = [
            'percentage' => $percentage,
            'up_to_people' => $upToPeople,
        ];
        return $this;
    }

    // Setters for annual promotional payments

    public function setAnnualPromotionalPayments( int $min, int $max, int $bonusCap = 0 ): static {
        $this->benefits[ 'annual_promotional_payments' ] = [
            'min' => $min,
            'max' => $max,
            'bonus_cap' => $bonusCap, // Optional annual bonus cap
        ];
        return $this;
    }

    // Getter for all benefits

    public function getBenefits(): array {
        return $this->benefits;
    }

    // Getter for specific benefit

    public function getBenefit( string $key ) {
        return $this->benefits[ $key ] ?? null;
    }

    // Dynamic setter for any deposit level ( e.g., deposit_1, deposit_2 )

    public function setDepositLevel( string $type, int $level, int $amount ): static {
        $benefitKey = "{$type}_referral_bonus";
        $depositKey = "deposit_{$level}";

        if ( isset( $this->benefits[ $benefitKey ] ) ) {
            $this->benefits[ $benefitKey ][ $depositKey ] = $amount;
        }

        return $this;
    }

    // Example of accessing dynamic values for a given deposit level

    public function getDepositLevel( string $type, int $level ): int {
        $benefitKey = "{$type}_referral_bonus";
        $depositKey = "deposit_{$level}";

        return $this->benefits[ $benefitKey ][ $depositKey ] ?? 0;
    }
}
