<?php

namespace App\Casts;

use App\Enums\StatusEnum;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Contracts\Database\Eloquent\CastsAttributes;

class StatusEnumCast implements CastsAttributes {
    /**
    * Cast the given value.
    *
    * @param  array<string, mixed>  $attributes
    */

    public function get( $model, string $key, $value, $attributes ) {
        return StatusEnum::from( $value );
    }

    /**
    * Prepare the given value for storage.
    *
    * @param  array<string, mixed>  $attributes
    */

    public function set( $model, string $key, $value, $attributes ) {
        return $value instanceof StatusEnum ? $value->value : $value;
    }
}
