<?php

namespace App\Jobs;

use App\Mail\BroadcastMail;
use App\Models\User;
use Illuminate\Bus\Queueable;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Foundation\Bus\Dispatchable;
use Illuminate\Queue\InteractsWithQueue;
use Illuminate\Queue\SerializesModels;
use Illuminate\Support\Facades\Log;
use Illuminate\Support\Facades\Mail;

class BroadcastJob implements ShouldQueue {
    use Dispatchable, InteractsWithQueue, Queueable, SerializesModels;

    public function __construct(
        public string $to,
        public string $subject,
        public string $content,
        public mixed $userData
    ) {
    }

    public function handle(): void {
        try {
            $this->userData = new User($this->userData);
            Mail::to( $this->to )->send( new BroadcastMail(
                mailContent: $this->content,
                mailSubject: $this->subject,
                user: $this->userData
            ) );
        } catch ( \Throwable $e ) {
            Log::error( 'BroadcastJob failed', [
                'to' => $this->to,
                'subject' => $this->subject,
                'error' => $e->getMessage(),
                'trace' => $e->getTraceAsString()
            ] );
        }
    }
}
