<?php

namespace App\Mail;

use Illuminate\Bus\Queueable;
use Illuminate\Mail\Mailable;
use Illuminate\Queue\SerializesModels;

class CsvExportMail extends Mailable {
    use Queueable, SerializesModels;

    public array $attached;

    public function __construct( $attached ) {
        $this->attached = $attached;
        // Array of [ 'path' => ..., 'filename' => ... ]
    }

    public function build() {
        $mail = $this->subject( 'Your CSV Export' )
        ->view( 'emails.csv_export' );

        // Attach all files from the attached array
        foreach ( $this->attached as $attachment ) {
            $mail->attach( $attachment[ 'path' ], [
                'as' => $attachment[ 'filename' ],
                'mime' => 'text/csv',
            ] );
        }

        return $mail;
    }
}
