<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Support\Carbon;
use Illuminate\Support\Facades\Hash;

class PinVerification extends Model
{
    use HasFactory;

    /**
     * The attributes that are mass assignable.
     *
     * @var array
     */
    protected $fillable = [
        'pin',
        'expires_at',
        'user_id',
    ];

    /**
     * The attributes that should be cast to native types.
     *
     * @var array
     */
    protected $casts = [
        'expires_at' => 'datetime',
    ];

    /**
     * Automatically set the default expiration time to 15 minutes if not provided.
     *
     * @var array
     */
    protected static function boot() {
        parent::boot();
        static::creating(function ($model) {
            if (!$model->expires_at) {
                $model->expires_at = Carbon::now()->addMinutes(15);
            }
        });
    }

    /**
     * Get the user that owns the pin verification.
     */
    public function user() {
        return $this->belongsTo(User::class);
    }

    public function verified(int $pin){
        if (!Hash::check( $pin, $this->pin ) ) {
            return false ;
        }
        return true;
    }
}
