<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class PromoUse extends Model {
    // Defining table name explicitly ( optional if table name follows convention )
    protected $table = 'promo_uses';

    // Enable mass assignment for specific attributes
    protected $fillable = [
        'user_id',
        'transaction_id',
        'promo_id',
        'additional_data',
    ];

    // Cast 'additional_data' as an array ( this is useful for JSON columns )
    protected $casts = [
        'additional_data' => 'array',
    ];

    // Defining relationships

    /**
    * Get the user that used the promo.
    */

    public function user() {
        return $this->belongsTo( User::class );
    }

    /**
    * Get the transaction associated with the promo use.
    */

    public function transaction() {
        return $this->belongsTo( Transaction::class );
    }

    /**
    * Get the promo associated with this promo use.
    */

    public function promo() {
        return $this->belongsTo( Promo::class );
    }
}
