<?php

namespace App\Telegram\Commands;

use App\Models\SystemSettings;
use App\Models\User;
use SergiX44\Nutgram\Nutgram;
use SergiX44\Nutgram\Handlers\Type\Command;
use Illuminate\Support\Facades\Log;
use SergiX44\Nutgram\Telegram\Properties\ParseMode;
use SergiX44\Nutgram\Telegram\Types\Keyboard\InlineKeyboardButton;
use SergiX44\Nutgram\Telegram\Types\Keyboard\InlineKeyboardMarkup;

class StartCommand extends Command
{
    protected string $command = 'start';
    protected ?string $description = 'Start the bot and link user account for notifications.';

    public function handle(Nutgram $bot): void
    {
        $text = $bot->message()->text;
        $parts = explode(' ', $text);
        $chatId = (string) $bot->chat()->id; // Ensure chat ID is string

        if (count($parts) > 1) {
            try {
                $commandData = $parts[1];
                $userEmail = $commandData;

                $user = User::where('email', $userEmail)
                    ->orWhere('referral_code', $userEmail)
                    ->first();

                if (!$user) {
                    $bot->sendMessage('User not found');
                    return;
                }

                $user->telegram_chat_id = $chatId;
                $user->telegram_id = $bot->message()->from->id;
                $user->save();

                $welcomeMessage = '<b>Congratulations!</b> 🎉' . PHP_EOL . PHP_EOL .
                    'You will now receive your account update notifications here on Telegram!' . PHP_EOL .
                    "Hi <b>{$user->name}</b>, I’m {$bot->getMe()->username}, your assistant for account updates and more. " . PHP_EOL . PHP_EOL .
                    'What you’ll get:' . PHP_EOL .
                    '💳 Transaction notifications' . PHP_EOL .
                    '🔐 Login alerts' . PHP_EOL .
                    '🤝 Referral updates' . PHP_EOL . PHP_EOL .
                    'Stay tuned for real-time updates about your account activities!' . PHP_EOL . PHP_EOL;

                $bot->sendMessage(
                    $welcomeMessage,
                    parse_mode: ParseMode::HTML,
                );

                Log::channel('telegram')->info("User linked for notifications: {$userEmail}, Chat ID: {$chatId}");
            } catch (\Throwable $e) {
                Log::channel('telegram')->error("Error in StartCommand: " . $e->getMessage());
                $bot->sendMessage(
                    'An error occurred while linking your account. Please try again or contact support.',
                    parse_mode: ParseMode::HTML
                );
            }
        } else {
            $bot->sendMessage(
                'Please provide your registered email on ' . system_setting(SystemSettings::SITE_NAME, '___') . ' using the format: /start your@email.com',
                parse_mode: ParseMode::HTML
            );
        }
    }
}
