<?php

use App\Enums\InterestPeriod;
use App\Enums\InterestPlan;
use App\Enums\InterestType;
use App\Enums\InvestmentSchemeType;
use App\Enums\PlanDurationPeriod;
use App\Enums\StatusEnum;
use App\Enums\ToggleStatus;
use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
         Schema::create('investment_schemes', function (Blueprint $table) {
            $table->id();
            $table->string('scheme_name');
            $table->string('learn_more_link');
            $table->string('sid', 100)->unique();
            $table->string('short_name');
            $table->text('description');
            $table->decimal('min_invest_amount', 12);
            $table->decimal('max_invest_amount', 12);
            $table->decimal('risk_exposure_percentage');
            $table->decimal('interest_rate');
            $table->enum('interest_type',  InterestType::getKeys());
            $table->enum('interest_period', InterestPeriod::getKeys());
            $table->string('name', 100)->nullable()->default('text');
            $table->integer('term_duration');
            $table->enum('term_duration_period', PlanDurationPeriod::asArray())->nullable()->default(PlanDurationPeriod::HOUR);
            $table->enum('status', StatusEnum::getKeys())->default(StatusEnum::INACTIVE);
            $table->enum('type', InvestmentSchemeType::getKeys())->default(InvestmentSchemeType::Basic);
            $table->decimal('compounding_bonus')->nullable()->default(0);
            $table->json('interest_plans');
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('invest_schemes');
    }
};
