<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void  {
        Schema::create('robots', function (Blueprint $table) {
        $table->id();
        $table->string('name');
        $table->decimal('renting_cost_per_hour', 8, 2);
        $table->integer('working_hours')->default(24);
        $table->integer('maintenance_interval_days')->default(182);
        $table->longText('ideal_use_case')->nullable();
        $table->string('media_url')->nullable();
        $table->integer('total_robots')->default(1);
        $table->integer('total_maintenance_fee')->default(0);
        $table->integer('total_rented')->default(0);
        $table->timestamp('last_maintained_at')->nullable();
        $table->timestamp('last_revenue_at')->nullable();
        $table->timestamps();
    });

    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('robots');
    }
};
