<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        Schema::table('investments', function (Blueprint $table) {
            $table->foreignId('applied_investment_tier_id')
                  ->nullable()
                  ->after('scheme_id')
                  ->constrained('investment_maturity_bonus_tiers')
                  ->nullOnDelete();

            $table->index('applied_investment_tier_id');
        });
    }

    public function down(): void
    {
        Schema::table('investments', function (Blueprint $table) {
            $table->dropForeign(['applied_investment_tier_id']);
            $table->dropColumn('applied_investment_tier_id');
        });
    }
};
