<?php declare( strict_types = 1 );

namespace App\Enums;

use BenSampo\Enum\Enum;

/**
* Enum representing different types of financial transactions.
*
* @method static static Deposit()
* @method static static Withdrawal()
* @method static static Transfer()
* @method static static Investment()
* @method static static ReInvestment()
* @method static static InvestedCapitalWithdrawal()
* @method static static Earnings()
* @method static static Bonus()
* @method static static Commission()
* @method static static Topupinvestment()
* @method static static FeeDeposit()
*/
final class TransactionType extends Enum {
    const Deposit = 'deposit';
    const Withdrawal = 'withdrawal';
    const Transfer = 'transfer';
    const Investment = 'investment';
    const ReInvestment = 'reinvestment';
    const InvestedCapitalWithdrawal = 'investedcapitalwithdrawal';
    const Earnings = 'earnings';
    const Bonus = 'bonus';
    const Commission = 'commission';
    const Topupinvestment = 'topupinvestment';
    const FeeDeposit = 'feedeposit';
}
