<?php

namespace App\Http\Controllers\Api;

use App\Http\Controllers\Controller;
use App\Models\AffiliatePackage;
use Illuminate\Http\Request;
use Exception;

class AffiliatePackageController extends Controller {
    /**
    * Display a listing of the resource.
    */

    public function index() {
        $packages = AffiliatePackage::all();
        return $this->success( $packages );
    }

    /**
    * Store a newly created resource in storage.
    */

    public function store( Request $request ) {
        $request->validate( [
            'name' => 'required|string|max:255',
            'description' => 'nullable|string',
            'benefits' => 'required|array',
            'benefits.direct_referral_bonus.deposit_1' => 'required|numeric',
            'benefits.direct_referral_bonus.deposit_2' => 'required|numeric',
            'benefits.direct_referral_bonus.deposit_3' => 'required|numeric',
            'benefits.direct_referral_bonus.referred_person_bonus' => 'required|numeric',
            'benefits.direct_referral_bonus.deposit_bonus_up_to_times' => 'required|integer',
            'benefits.weekly_profit_from_direct.percentage' => 'required|numeric',
            'benefits.weekly_profit_from_direct.up_to_people' => 'required|integer',
            'benefits.indirect_referral_bonus.deposit_1' => 'required|numeric',
            // 'benefits.indirect_referral_bonus.deposit_2' => 'required|numeric',
            // 'benefits.indirect_referral_bonus.deposit_3' => 'required|numeric',
            'benefits.indirect_referral_bonus.levels' => 'required|integer',
            'benefits.monthly_profit_from_indirects.percentage' => 'required|numeric',
            'benefits.monthly_profit_from_indirects.up_to_people' => 'required|integer',
            // 'benefits.annual_promotional_payments.min' => 'required|numeric',
            // 'benefits.annual_promotional_payments.max' => 'required|numeric',
            'benefits.required_indirect_referrals' => 'required|integer',
            // 'is_system_default' => 'required|boolean',
            'required_referrals_to_join' => 'required|integer',
            'benefits.premium_deposit_benefit' => 'required|integer',
            'benefits.min_referrals_required_for_cashout' => 'required|integer',
        ] );

        $package = AffiliatePackage::create( $request->all() );
        return $this->success( $package, 'Package created successfully', 201 );
    }

    /**
    * Display the specified resource.
    */

    public function show( string $id ) {
        try {
            $package = AffiliatePackage::findOrFail( $id );
            return $this->success( $package );
        } catch ( Exception $e ) {
            return $this->error( 'Package not found', 404, $e->getMessage() );
        }
    }

    /**
    * Update the specified resource in storage.
    */

    public function update( Request $request, string $id ) {
        $package = AffiliatePackage::findOrFail( $id );

        $request->validate( [
            'name' => 'sometimes|string|max:255',
            'description' => 'sometimes|nullable|string',
            'benefits' => 'sometimes|array',
            'benefits.direct_referral_bonus.deposit_1' => 'sometimes|numeric',
            'benefits.direct_referral_bonus.deposit_2' => 'sometimes|numeric',
            'benefits.direct_referral_bonus.deposit_3' => 'sometimes|numeric',
            'benefits.direct_referral_bonus.referred_person_bonus' => 'sometimes|numeric',
            'benefits.direct_referral_bonus.deposit_bonus_up_to_times' => 'sometimes|integer',
            'benefits.weekly_profit_from_direct.percentage' => 'sometimes|numeric',
            'benefits.weekly_profit_from_direct.up_to_people' => 'sometimes|integer',
            'benefits.indirect_referral_bonus.deposit_1' => 'sometimes|numeric',
            // 'benefits.indirect_referral_bonus.deposit_2' => 'sometimes|numeric',
            // 'benefits.indirect_referral_bonus.deposit_3' => 'sometimes|numeric',
            'benefits.indirect_referral_bonus.levels' => 'sometimes|integer',
            'benefits.monthly_profit_from_indirects.percentage' => 'sometimes|numeric',
            'benefits.monthly_profit_from_indirects.up_to_people' => 'sometimes|integer',
            // 'benefits.annual_promotional_payments.min' => 'sometimes|numeric',
            // 'benefits.annual_promotional_payments.max' => 'sometimes|numeric',
            'benefits.required_indirect_referrals' => 'sometimes|integer',
            // 'is_system_default' => 'sometimes|boolean',
            'required_referrals_to_join' => 'sometimes|integer',
            'benefits.premium_deposit_benefit' => 'required|integer',
            'benefits.min_referrals_required_for_cashout' => 'required|integer',
        ] );

        $package->update( array_filter( $request->all(), fn( $value ) => !is_null( $value ) ) );

        return $this->success( $package, 'Package updated successfully' );
    }

    /**
    * Remove the specified resource from storage.
    */

    public function destroy( string $id ) {
        try {
            $package = AffiliatePackage::findOrFail( $id );
            $package->delete();

            return $this->success( null, 'Package deleted successfully' );
        } catch ( Exception $e ) {
            return $this->error( 'Failed to delete package', errors:  $e->getMessage() );
        }
    }
}
