<?php

namespace App\Http\Controllers\Api\Home;

use App\Http\Controllers\Controller;
use App\Http\Requests\InvestmentRequest;
use App\Models\Transaction;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Log;

class InvestmentController extends Controller {
    /**
    * Display a listing of the resource.
    */

    public function index(Request $request) {
        $user = $request->user();
        $investments = $user->investments()->with('transaction')->get();
        return $this->success($investments);
    }

    /**
    * Show the form for creating a new resource.
    */

    public function create() {
        //
    }

    /**
    * Store a newly created resource in storage.
    */

    public function store(InvestmentRequest $investmentRequest) {
        $user = $investmentRequest->user();

        try {
            $transaction = DB::transaction(function () use ($user, $investmentRequest) {
                if($tid = $investmentRequest->input('tid')){
                    $transaction = Transaction::where( 'id', $tid )->firstOrFail();
                    $investmentId = $transaction->investment->id;
                    return $user->topUpInvestment(
                        $investmentRequest->input('amount_usd'), 0, [
                            ...$investmentRequest['payment_method'],
                            "investment_id" => $investmentId,
                            "description" => $investmentRequest->input('description')
                        ]
                    );
                }
                return $user->createInvestmentDeposit($investmentRequest->validated());
            });
        } catch (\Throwable $th) {
            Log::error("Error In InvestmentController -> store: ".$th->getMessage());
            return $this->error('Failed to create investment', 500, $th->getMessage());
        }

        return $this->success($transaction, 'Investment created successfully.');
    }

    /**
    * Display the specified resource.
    */

    public function show( string $id ) {
        //
    }

    /**
    * Show the form for editing the specified resource.
    */

    public function edit( string $id ) {
        //
    }

    /**
    * Update the specified resource in storage.
    */

    public function update( Request $request, string $id ) {
        $transaction = Transaction::find($id);
        if(!$transaction){
           return $this->error("Transaction not found.");
        }
        try {
            $transaction = $transaction = DB::transaction(function () use ($transaction, $request) {
               return $transaction->setTransactionStatus($request['status']);
            });
        } catch (\Throwable $th) {
            return $this->error("Error updating Transaction.", 500, $th->getMessage());
        }
        return $this->success( $transaction, 'Trnsaction updated');
    }

    /**
    * Remove the specified resource from storage.
    */

    public function destroy( string $id ) {
        //
    }
}
