<?php

namespace App\Http\Requests\Api;

use App\Enums\UserWalletType;
use App\Models\SystemSettings;
use Illuminate\Foundation\Http\FormRequest;

class WithdrawalRequest extends FormRequest {
    /**
    * Determine if the user is authorized to make this request.
    *
    * @return bool
    */

    public function authorize() {
        return true;
        // Set to false if authorization logic is needed
    }

    /**
    * Get the validation rules that apply to the request.
    *
    * @return array
    */

    public function rules() {
        $maxWithdrawalAmount = ( int )system_setting( SystemSettings::MAX_WITHDRAWAL_AMOUNT, config( 'system_settings.maximum_withdrawal_amount', 10 ) );
        $minWithdrawalAmount = ( int )system_setting( SystemSettings::MIN_WITHDRAWAL_AMOUNT, 1 );

        return [
            'amount_usd' => 'required|numeric|min:' . $minWithdrawalAmount . '|max:' . $maxWithdrawalAmount,
            'amount_crypto' => 'sometimes|numeric',
            'method_info' => 'required|array',
            'method_info.address' => 'required|string',
            'method_info.network' => 'required|string',
            'wallet_from' => 'required|in:' . implode( ',', UserWalletType::asArray() ),
        ];
    }

    /**
    * Customize the error messages for validation rules.
    *
    * @return array
    */

    public function messages() {
        return [
            'amount_usd.required' => 'The USD amount is required.',
            'amount_usd.numeric' => 'The USD amount must be a number.',
            'amount_usd.min' => 'The USD amount must be at least :min.',
            'amount_usd.max' => 'The USD amount cannot exceed :max.',
            'amount_crypto.required' => 'The crypto amount is required.',
            'amount_crypto.numeric' => 'The crypto amount must be a number.',
            'amount_crypto.min' => 'The crypto amount must be at least :min.',
            'amount_crypto.max' => 'The crypto amount cannot exceed :max.',
            'method_info.required' => 'Method information is required.',
            'method_info.array' => 'Method information must be an array.',
            'method_info.address.required' => 'The wallet address is required.',
            'method_info.address.string' => 'The address must be a string.',
            'method_info.network.required' => 'The network is required.',
            'method_info.network.string' => 'The network must be a string.',
            'wallet_from.required' => 'The wallet type is required.',
            'wallet_from.in' => 'The selected wallet type is invalid.',
        ];
    }
}
