<?php

namespace App\Http\Requests;

use App\Enums\InterestPeriod;
use App\Enums\InterestType;
use App\Enums\InvestmentSchemeType;
use App\Enums\PlanDurationPeriod;
use App\Enums\StatusEnum;
use Illuminate\Foundation\Http\FormRequest;
use Illuminate\Support\Facades\Log;

class InvestmentSchemeRequest extends FormRequest {
    /**
    * Determine if the user is authorized to make this request.
    */

    public function authorize(): bool {
        // Set this to true if the user is authorized to make this request.
        return true;
    }

    /**
    * Get the validation rules that apply to the request.
    *
    * @return array<string, \Illuminate\Contracts\Validation\ValidationRule|array<mixed>|string>
    */

    public function rules(): array {
        return [
            'scheme_name' => 'required|string|max:255',
            'short_name' => 'required|string|max:5',
            'learn_more_link' => 'required|string|max:255',
            'description' => 'required|string',
            'min_invest_amount' => 'required|numeric|min:0',
            'max_invest_amount' => 'required|numeric|gt:min_invest_amount',
            'risk_exposure_percentage' => [ 'numeric', 'min:0' ],
            'interest_rate' => 'required|numeric|min:0',
            'interest_type' => 'required|in:'.implode( ',', InterestType::asArray() ),
            // 'interest_plans' => 'required|array',
            'interest_period' => 'required|in:' . implode( ',', InterestPeriod::asArray() ),
            'type' => 'required|in:' . implode( ',', InvestmentSchemeType::asArray() ),
            'term_duration_period' => 'required|in:' . implode( ',', PlanDurationPeriod::asArray() ),
            'term_duration' => 'required|integer',
            'status' => 'required|string|in:' .implode( ',', [ StatusEnum::ACTIVE, StatusEnum::INACTIVE ] ),
            'compounding_bonus' => [ 'nullable', 'numeric' ],
        ];
    }
}
