<?php

namespace App\Mail;

use App\Models\Transaction;
use Illuminate\Bus\Queueable;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Mail\Mailable;
use Illuminate\Mail\Mailables\Content;
use Illuminate\Mail\Mailables\Envelope;
use Illuminate\Queue\SerializesModels;

class DepositApprovedEmail extends Mailable {
    use Queueable, SerializesModels;

    /**
    * Create a new message instance.
    */

    public function __construct( public Transaction $transaction ) {
        //
    }

    /**
    * Get the message envelope.
    */

    public function envelope(): Envelope {
        return new Envelope(
            subject: 'Your Investment Is Confirmed — The Robots Are Now in Motion',
        );
    }

    /**
    * Get the message content definition.
    */

    public function content(): Content {
        return new Content(
            view: 'emails.transactions.deposit-approved',
            with:[ 'user' => $this->transaction->user, 'transaction' => $this->transaction ]
        );
    }

    /**
    * Get the attachments for the message.
    *
    * @return array<int, \Illuminate\Mail\Mailables\Attachment>
    */

    public function attachments(): array {
        return [];
    }
}
