<?php

namespace App\Models;

use App\Enums\AudienceGroupEnum;
use App\Enums\StatusEnum;
use Illuminate\Database\Eloquent\Builder;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Support\Facades\Log;

class Promo extends Model {

    protected $fillable = [
        'title',
        'description',
        'type',
        'discount_or_bonus',
        'start_amount',
        'start_date',
        'end_date',
        'scheme_id',
        'status',
        'audience'
    ];

    public function scheme() {
        return $this->belongsTo( InvestmentScheme::class );
    }

    public function uses() {
        return $this->hasMany( PromoUse::class );
    }

    // public function getTypeAttribute( $value ) {
    //     return ucfirst( $value );
    // }

    public function scopeActive( $query ) {
        return $query->where( 'status', StatusEnum::ACTIVE )
        ->where( 'start_date', '<=', now() )
        ->where( 'end_date', '>=', now() );
    }

    public function scopeForAudience($query, array|string $audiences) {
        $audiences = is_array($audiences) ? $audiences : [$audiences];

        return $query->where(function ($q) use ($audiences) {
            // Promos for "all" or no audience
            $q->whereNull('audience')
              ->orWhere('audience', AudienceGroupEnum::All()->value);

            // Promos that explicitly match any of the user's audiences
            if (!empty($audiences)) {
                $q->orWhereIn('audience', $audiences);
            }
        })->tap(function ($q) use ($audiences) {
            
        });
    }

}
