<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Support\Str;
use OwenIt\Auditing\Contracts\Auditable;

class Referral extends Model implements Auditable {
    use HasFactory, \OwenIt\Auditing\Auditable;

    /**
    * The attributes that are mass assignable.
    *
    * @var array<int, string>
    */
    protected $fillable = [
        'downline_id',
        'referee_id',
    ];

    /**
    * Get the user that is the downline in this referral.
    */

    public function downline() {
        return $this->belongsTo( User::class, 'downline_id' );
    }

    /**
    * Get the user that is the referee in this referral.
    */

    public function referee() {
        return $this->belongsTo( User::class, 'referee_id' );
    }

    /**
    * Generate a unique referral code for the user.
    *
    * @return string
    */
    public static function makeReferralCode(): string {
        // Generate a unique string using Laravel's Str helper
        // You could use the referee_id, timestamp, or other combinations for uniqueness
        return strtoupper('DNX'.Str::random( 6 ) );
    }
}
