<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class Robot extends Model {
    protected $fillable = [
        'name',
        'renting_cost_per_hour',
        'working_hours',
        'maintenance_interval_days',
        'ideal_use_case',
        'media_url',
        'total_robots',
        'last_maintained_at',
        'total_maintenance_fee',
        'total_rented',
        'last_revenue_at'
    ];

    protected $casts = [
        'last_maintained_at' => 'datetime',
        'last_revenue_at' => 'datetime',
    ];

    public function rentals() {
        return $this->hasMany( Rental::class );
    }
}
