<?php

namespace App\Providers;

use App\Models\Investment;
use App\Models\Transaction;
use App\Models\User;
use App\Observers\InvestmentObserver;
use App\Observers\TransactionObserver;
use App\Observers\UserObserver;
use Illuminate\Cache\RateLimiting\Limit;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\RateLimiter;
use Illuminate\Support\ServiceProvider;

class AppServiceProvider extends ServiceProvider {
    /**
    * Register any application services.
    */

    public function register(): void {
        //
    }

    /**
    * Bootstrap any application services.
    */

    public function boot(): void {
        Transaction::observe( TransactionObserver::class );
        User::observe( UserObserver::class );
        Investment::observe( InvestmentObserver::class );
        RateLimiter::for('admin', function (Request $request) {
            return Limit::perMinute(20)->by($request->user()?->id ?: $request->ip());
        });
        RateLimiter::for('global', function (Request $request) {
            return Limit::perMinute(100)->by($request->user()?->id ?: $request->ip());
        });
    }
}
