<?php

namespace App\Telegram\Commands;

use App\Models\User;
use SergiX44\Nutgram\Nutgram;
use SergiX44\Nutgram\Handlers\Type\Command;
use Illuminate\Support\Facades\Log;
use SergiX44\Nutgram\Telegram\Properties\ParseMode;

class DisconnectCommand extends Command
 {
    protected string $command = 'disconnect';

    protected ?string $description = 'Disconnect your Telegram account from receiving notifications.';

    public function handle( Nutgram $bot ): void
 {
        $chatId = ( string ) $bot->chat()->id;
        // Ensure chat ID is string
        $telegramId = $bot->message()->from->id;

        try {
            $user = User::where( 'telegram_chat_id', $chatId )
            ->where( 'telegram_id', $telegramId )
            ->first();

            if ( !$user ) {
                $bot->sendMessage(
                    'No linked account found for this Telegram chat. Use /start to connect your account first.',
                    parse_mode: ParseMode::HTML
                );
                return;
            }

            $user->telegram_chat_id = null;
            $user->telegram_id = null;
            $user->save();

            $bot->sendMessage(
                '<b>Account Disconnected!</b> 🎉' . PHP_EOL . PHP_EOL .
                'Your Telegram account has been successfully disconnected. ' . PHP_EOL .
                'You will no longer receive notifications here.' . PHP_EOL . PHP_EOL .
                'To reconnect, use /start with your email address.',
                parse_mode: ParseMode::HTML
            );

            Log::channel( 'telegram' )->info( "User disconnected Telegram: Chat ID {$chatId}" );
        } catch ( \Throwable $e ) {
            Log::channel( 'telegram' )->error( 'Error in DisconnectCommand: ' . $e->getMessage() );
            $bot->sendMessage(
                'An error occurred while disconnecting your account. Please try again or contact support.',
                parse_mode: ParseMode::HTML
            );
        }
    }
}
