<?php

use App\Http\Middleware\AdminIpWhitelist;
use App\Http\Middleware\AdminMiddleware;
use App\Http\Middleware\CheckUserIp;
use App\Http\Middleware\Ensure2FAEnabled;
use App\Http\Middleware\ForceJsonResponse;
use App\Http\Middleware\Require2FA;
use App\Http\Middleware\RequireFresh2FA;
use Illuminate\Foundation\Application;
use Illuminate\Foundation\Configuration\Exceptions;
use Illuminate\Foundation\Configuration\Middleware;
use Illuminate\Console\Scheduling\Schedule;
use Illuminate\Database\QueryException;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Log;

return Application::configure(basePath: dirname(__DIR__))
    ->withRouting(
        web: __DIR__.'/../routes/web.php',
        api: __DIR__.'/../routes/api.php',
        commands: __DIR__.'/../routes/console.php',
        health: '/up',
    )
    ->withMiddleware(function (Middleware $middleware) {
        $middleware
        ->group('json-response',[ForceJsonResponse::class])
        ->group('ensure-2fa-enabled', [Ensure2FAEnabled::class])
        ->group('require-2fa-code', [Require2FA::class])
        ->group('admin', [AdminMiddleware::class, AdminIpWhitelist::class, RequireFresh2FA::class, CheckUserIp::class]);
    })->withSchedule(function(Schedule $schedule){
        $schedule->command('app:process-matured-investments')->everyMinute();
    })
    ->withExceptions(function (Exceptions $exceptions) {
        $exceptions->renderable(function (QueryException $e, $request) {
            Log::warning('QueryException occurred: ' . $e->getMessage());

            // Refresh DB connection
            DB::purge('mysql');
            DB::reconnect('mysql');

            return response()->json([
                'message' => 'Something went wrong. Please try again.',
                'error' => config('app.debug') ? $e->getMessage() : null,
            ], 500);
        });
    })
    ->create();
