<?php

use App\Models\SystemSettings;

// Fetch settings from the database or use default values
return [
    SystemSettings::SITE_NAME => config( 'app.name', 'Default Site Name' ),
    SystemSettings::SITE_URL => config( 'app.url', 'https://defaultsite.com' ),
    SystemSettings::ADMIN_EMAIL => env( 'ADMIN_EMAIL', 'admin@default.com' ),
    SystemSettings::SUPPORT_EMAIL => env( 'SUPPORT_EMAIL', 'support@default.com' ),
    SystemSettings::HEADER_CONTENTS => '',
    SystemSettings::FOOTER_CONTENTS => '',
    SystemSettings::MAINTENANCE_MODE => false,
    SystemSettings::TERMS_CONDITIONS => 'Please read and agree to our terms and conditions.',
    SystemSettings::ALLOW_REGISTRATION => true,
    SystemSettings::MUST_VERIFY_EMAIL => true,
    SystemSettings::MUST_BE_APPROVED => true,
    SystemSettings::ADMIN_PHONE => '',
    SystemSettings::PLATFORM_ADDRESS => '98, De Beauvoir Rd, London N1 4EN, UK',
    SystemSettings::ADMIN_WHATSAPP_PHONE => '',
    SystemSettings::INTEREST_FREQUENCY_HOURS => 0.0167,
    SystemSettings::MIN_WITHDRAWAL_AMOUNT => 5,
    SystemSettings::MAX_WITHDRAWAL_AMOUNT => 10,
    SystemSettings::NOTIFICATION_EMAIL => env( 'NOTIFICATION_EMAIL', 'notify@default.com' ),
    SystemSettings::MAX_PENDING_WITHDRAWALS => 1,
    SystemSettings::PREMIUM_DEPOSIT_BONUS => 1,
    SystemSettings::MIN_REINVESTMENT_AMOUNT => 5,
    SystemSettings::MIN_TOPUP_PERCENTAGE => 5,
    SystemSettings::MAX_REFERRAL_COMMISSION_LEVEL => 5,
    SystemSettings::MAX_SUB_DEPOSIT_COMMISION_LIMIT =>3,
    //
    SystemSettings::INITIAL_DEPOSIT_BONUS_PERCENTAGE => 8,
    SystemSettings::INITIAL_DEPOSIT_BENEFIT_PERCENTAGE => 1,
    SystemSettings::MIN_REFERRALS_REQUIRED_FOR_CASHOUT => 2,
    SystemSettings::ENABLED_2FA => true,
    SystemSettings::REQUIRE_2FA => true,
];
