<?php

use App\Enums\StatusEnum;
use App\Enums\TransactionType;
use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateTransactionsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('transactions', function (Blueprint $table) {
            $table->id();
            $table->decimal('amount_usd', 15, 8);
            $table->decimal('amount_crypto', 15, 8);
            $table->json('method_info')->nullable();
            $table->enum('status', StatusEnum::asArray())->default(StatusEnum::PENDING);
            $table->enum('type', TransactionType::asArray());
            $table->timestamp('expire_time')->nullable();
            $table->timestamps();
            $table->unsignedBigInteger('user_id');
            $table->foreign('user_id')->references('id')->on('users')->onDelete('cascade');
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('transactions');
    }
}
