<?php

use App\Enums\InterestPlan;
use App\Enums\StatusEnum;
use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void {
        Schema::create('investments', function (Blueprint $table) {
            $table->id();
            $table->unsignedBigInteger('transaction_id');
            $table->date('investment_end_date');
            $table->dateTime('last_roi_date')->nullable();
            $table->dateTime('next_payout_time')->nullable();
            $table->dateTime('last_monthly_upline_reward_time')->nullable();
            $table->dateTime('last_weekly_upline_reward_time')->nullable();
            $table->decimal('total_returns',  18, 8)->nullable()->default(0);
            $table->decimal('amount_invested',  15, 8);
            $table->decimal('last_roi_amount',  15, 8);
            $table->enum('status', StatusEnum::asArray())->nullable()->default(StatusEnum::PENDING);
            $table->unsignedBigInteger('scheme_id');

            $table->foreign('scheme_id')
                ->references('id')
                ->on('investment_schemes')
                ->onDelete('cascade')
                ->onUpdate('restrict');  // Prevent updates

            $table->enum('interest_plan', InterestPlan::asArray())->nullable()->default(InterestPlan::FLEXIBLE);

            $table->foreign('transaction_id')
                ->references('id')
                ->on('transactions')
                ->onDelete('cascade');

            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void {
        Schema::dropIfExists('investments');
    }
};
