<?php

use App\Enums\StatusEnum;
use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
    /**
    * Run the migrations.
    */
    public function up(): void {
        Schema::create('user_affiliate_packages', function (Blueprint $table) {
            $table->id();
            $table->foreignId('user_id')
                ->constrained('users')
                ->onDelete('cascade')
                ->unique();
            $table->foreignId('affiliate_package_id')
                ->constrained('affiliate_packages')
                ->onDelete('restrict');
            $table->enum('status', StatusEnum::asArray())
                ->default(StatusEnum::INACTIVE);
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('user_affiliate_packages' );
        }
    }
    ;
