<?php

use App\Http\Controllers\Api\AffiliatePackageController;
use Illuminate\Support\Facades\Route;
use App\Http\Controllers\Api\Admin\AdminController;
use App\Http\Controllers\Api\InvestmentSchemeController;
use App\Http\Controllers\Api\Auth\AuthController;
use App\Http\Controllers\Api\FrontController;
use App\Http\Controllers\Api\Home\AccountController;
use App\Http\Controllers\Api\Home\InvestmentController;
use App\Http\Controllers\Api\PaymentMethodController;
use App\Http\Controllers\Api\PromotionalMaterialController;
use App\Http\Controllers\Api\Auth\PinVerificationController;
use App\Http\Controllers\Api\RobotRentalController;
use App\Http\Controllers\Api\VoucherController;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Log;
use Illuminate\Support\Facades\Response;
use Illuminate\Support\Facades\File;

Route::middleware(['json-response', 'throttle:global'])->group(function(){
    // Public routes for login and registration
    Route::get('admin-settings', [FrontController::class, 'admin_settings']);
    Route::post('login', [AuthController::class, 'login']);
    Route::post('register', [AuthController::class, 'register']);
    Route::post('/send-pin', [PinVerificationController::class, 'sendPin']);
    Route::post('/verify-pin', [PinVerificationController::class, 'verifyPin']);
    Route::post('reset-password', [AuthController::class, 'reset_password']);
    Route::get('/marketing-material/{id}', [PromotionalMaterialController::class, 'show']);
    Route::get('/ref', [PromotionalMaterialController::class, 'socialMediaPreviewMaterial']);
    Route::apiResource('/investment-scheme', InvestmentSchemeController::class)->only(['index', 'show']);
    Route::get('fetch-rentals', [RobotRentalController::class, 'getRentals']);

    Route::get('/download-media', function (Request $request) {
        $mediaUrl = $request->query('media_url');
        $filePath = public_path('dia/' . basename($mediaUrl));
        if (file_exists($filePath)) {
            $mimeType = mime_content_type($filePath);
            $fileContents = File::get($filePath);
            $headers = [
                'Content-Type' => $mimeType,
                'Content-Disposition' => 'attachment; filename="' . basename($filePath) . '"',
            ];
            return Response::make($fileContents, 200, $headers);
        } else {
            // Handle file not found error
            Log::error('File does not exist: ' . $filePath);
            return response()->json(['error' => 'File not found'], 404);
        }
    });

    // Protected routes using Sanctum middleware
    Route::middleware(['auth:sanctum', 'ensure-2fa-enabled'])->group(function () {

        // Account and user actions
        Route::post('logout', [AuthController::class, 'logout']);
        Route::get('pending-payment', [AccountController::class, 'pending_payment']);
        Route::post('account', [AccountController::class, 'user_account']);
        Route::post('enable-2fa', [AccountController::class, 'enable2FA']);
        Route::post('verify-2fa', [AccountController::class, 'verify2FA']);
        Route::post('generate-2fa', [AccountController::class, 'generate2FA']);
        Route::post('disable-2fa', [AccountController::class, 'disable2FA']);
        Route::put('account-update', [AccountController::class, 'user_account_update']);
        Route::post('set-transaction-waiting', [AccountController::class, 'set_payment_waiting']);
        Route::post('set-transaction-payment-method/{id}', [AccountController::class, 'set_transaction_payment_method']);
        Route::post('cancel-transaction', [AccountController::class, 'cancel_transaction']);
        Route::post('request-withdrawal', [AccountController::class, 'request_withdrawal']);
        Route::post('finance-history', [AccountController::class, 'finance_history']);
        Route::post('compound-investment', [AccountController::class, 'compound_investment']);
        Route::post('reinvest-investment', [AccountController::class, 'reinvest_investment']);
        Route::post('join-affiliate-package/{id}', [AccountController::class, 'join_affiliate_package']);

        Route::post('calculate-voucher-discount', [VoucherController::class, 'calculateDiscount']);
        Route::post('cashout-affiliate-bonus', [AccountController::class, 'cashout_affiliate_bonus']);

        // API Resources
        Route::apiResource('/investment', InvestmentController::class)->only(['index', 'store', 'show']);
        Route::apiResource('/payment-method', PaymentMethodController::class)->only(['index', 'show']);
        Route::apiResource('/marketing-material', PromotionalMaterialController::class)->only(['index', 'show']);

        Route::get('fetch-transaction/{id}', [AccountController::class, 'fetch_transaction']);
        Route::post('close-investment/{investment}', [AccountController::class, 'close_investment']);

        // Admin-specific routes with 'admin' middleware
        Route::middleware(['admin', 'throttle:admin'])->group(function () {
            Route::apiResource('/investment-scheme', InvestmentSchemeController::class)->only(['update','store', 'destroy']);
            Route::apiResource('/investment', InvestmentController::class)->only(['destroy', 'update']);
            Route::apiResource('/payment-method', PaymentMethodController::class);
            Route::apiResource('/marketing-material', PromotionalMaterialController::class);

            // Admin Controller actions
            Route::controller(AdminController::class)->group(function () {
                Route::get('/admin-fetch-transactions', 'admin_get_transactions');
                Route::get('/admin-dashboard', 'admin_dashboard');
                Route::get('/admin-get-users', 'admin_get_users');
                Route::get('/admin-get-user/{user_id}', 'admin_get_user');
                Route::get('/admin-get-schemes', 'admin_get_schemes');
                Route::get('/admin-get-payment-methods', 'admin_get_payment_methods');
                Route::put('/admin-update-settings', 'admin_update_settings');
                Route::put('/admin-update-transaction/{id}', 'admin_update_transaction');
                Route::put('/admin-update-user-account/{id}', 'admin_update_user_account');
                Route::post('/admin-update-user-aff-package/{id}', 'admin_update_user_aff_package');

                Route::post('/admin-add-transaction', 'add_transaction');
                Route::delete('/admin-delete-user',  'delete_user_account');
                // Admin can create a new promo
                Route::post('admin-create-promo', 'add_promo');
                // Admin can update an existing promo
                Route::put('admin-update-promo/{id}', 'update_promo');
                // Admin can delete a promo
                Route::delete('admin-delete-promo/{id}', 'delete_promo');
                Route::post('admin-export-users', 'exportUsers');
                Route::post('admin-broadcast-email', 'broadcast_email');
                Route::post('admin-create-charge-fee-transactions', 'admin_create_charge_fee_transactions');

                Route::post('admin-create-maturity-bonus-tiers', 'admin_create_maturity_bonus_tier');
                Route::put('admin-update-maturity-bonus-tiers/{bonusTier}', 'admin_update_maturity_bonus_tier');
            });

            // Admin-specific updates and deletions
            Route::put('admin-update-affiliate-package/{id}', [AffiliatePackageController::class, 'update']);
            Route::put('/admin-update-payment-method/{id}', [PaymentMethodController::class, 'update']);
            Route::put('/admin-update-scheme/{id}', [InvestmentSchemeController::class, 'update']);
            Route::put('admin-update-voucher/{voucher}', [VoucherController::class, 'update']);    // Update a voucher

            //
            Route::post('admin-create-rental-robot', [RobotRentalController::class, 'createRobot']);
            Route::post('admin-create-rental-company', [RobotRentalController::class, 'createCompany']);
            Route::post('admin-create-rental', [RobotRentalController::class, 'createRental']);
            Route::post('admin-create-affiliate-package', [AffiliatePackageController::class, 'store']);
            Route::post('admin-create-voucher', [VoucherController::class, 'createVoucher']);
            Route::post('admin-reset-voucher/{voucher}', [VoucherController::class, 'reset']);

            Route::delete('admin-delete-voucher/{voucher}', [VoucherController::class, 'destroy']); // Delete a voucher
            Route::delete('/admin-delete-payment-method/{id}', [PaymentMethodController::class, 'destroy']);
            Route::delete('/admin-delete-scheme/{id}', [InvestmentSchemeController::class, 'destroy']);
            Route::delete('admin-delete-rental-robot/{id}', [RobotRentalController::class, 'deleteRobot']);
            Route::delete('admin-delete-rental/{id}', [RobotRentalController::class, 'deleteRental']);
            Route::delete('admin-delete-rental-company/{id}', [RobotRentalController::class, 'deleteCompany']);
            Route::delete('admin-delete-affiliate-package/{id}', [AffiliatePackageController::class, 'destroy']);

            Route::post('admin-update-rental-robot/{id}', [RobotRentalController::class, 'updateRobot']);
            Route::post('admin-update-rental-company/{id}', [RobotRentalController::class, 'updateCompany']);
            Route::post('admin-update-rental/{id}', [RobotRentalController::class, 'updateRental']);

        });
    });
});
